<?php 
/*
Plugin Name: My Caorusel
Description: Plugin untuk menambahkan potongan slides dengan Swiper JS.
Version: 1.0
Author: Wahyudi
*/

// Enqueue Swiper JS and CSS
function enqueue_swiper() {
     wp_enqueue_style('style', plugin_dir_url(__FILE__) . 'style.css');
    wp_enqueue_style('swiper-css', plugin_dir_url(__FILE__) . 'swiper-bundle.min.css');
    wp_enqueue_script('swiper-js', plugin_dir_url(__FILE__) . 'swiper-bundle.min.js', null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_swiper');

// Create Shortcode caridokter
// Shortcode: [mycarousel post_type="post" per_slide="3" delay="2000"]
global $post;
function create_mycarousel_shortcode($atts)
{

  // Attributes
  $atts = shortcode_atts(
    array(
      'post_type' => 'post',
      'per_slide'=> 3,
      'mobile_per_slide'=> 1,
      'delay'=>2000

    ),
    $atts,
    'mycarousel'
  );
  // Attributes in var
  $post_type = $atts['post_type'];
  $per_slide = $atts['per_slide'];
  $mobile_per_slide = $atts['mobile_per_slide'];
  $delay = $atts['delay'];

  $args = [
    'post_type' => $post_type,
    'posts_per_page' => 5,

  ];
  $slide = new WP_Query($args);

  ob_start();
?>
  <div>
    <?php if ($slide->have_posts()) : ?>
      <div class="swiper w-full relative">
        <div class="swiper-wrapper flex ">
          <?php while ($slide->have_posts()) : $slide->the_post();
            if (has_post_thumbnail()) {
              $bg = get_the_post_thumbnail_url();
            } ?>
            <div class="swiper-slide">
              <div class="slide-item" style="background: url('<?php echo $bg ?>') no-repeat center; background-size: cover;">
               <div class="layer"></div>
               <div class="slide-text">
               <?php //  the_title(sprintf('<h4 class="entry-title"><a href="%s" rel="bookmark">', esc_u(get_permalink())), '</a></h4>'); ?>
               <?php the_title('<h4>','</h4>' );?>
                <?php the_excerpt(10) ?>
               </div>
               
              </div>
            </div>
          <?php endwhile; ?>
        </div>
      </div>
    <?php endif;

    wp_reset_postdata(); ?>
  </div>
<script>
    
const swiper = new Swiper('.swiper', {
    // Optional parameters
    loop: true,
    slidesPerView: <?php echo $mobile_per_slide ?>,
    spaceBetween:30,
    autoplay:{
      delay:<?php echo $delay; ?>,
    },
    speed:1500,
  
    // If we need pagination
    pagination: {
      el: '.slide-pagination',
      
      clickable: true,

    },
    /* 
    untuk custom pagination
    renderBullet: function (index, className) {
          return '<span class="' + className + '">' + (index + 1) + "</span>";
        }, */
  
    // Navigation arrows
    navigation: {
      nextEl: '.slide-next',
      prevEl: '.slide-prev',
    },
    breakpoints:{
        640: {
          slidesPerView: <?php echo $per_slide ?>,
          spaceBetween: 10,
        },
        1024: {
          slidesPerView: 3,
          spaceBetween: 10,
        },
   }
  });
</script>
<?php
  $output = ob_get_clean();

  // Kembalikan konten yang telah dimodifikasi atau diambil
  return $output;
}
add_shortcode('mycarousel', 'create_mycarousel_shortcode');

// Set excerpt length to 10 words
function set_excerpt_length($length) {
    return 10;
}
add_filter('excerpt_length', 'set_excerpt_length');
?>